#ifdef GL_ES
precision mediump float;

varying float specular;
varying float diffuse;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in float specular;
in float diffuse;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif

    fragColor = vec4(vec3((diffuse * tColor.r) + (specular * tColor.g)), tColor.a);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
